<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Options;
use Twilio\Values;

abstract class RateLimitOptions {
    /**
     * @param string $description Description of this Rate Limit
     * @return CreateRateLimitOptions Options builder
     */
    public static function create(string $description = Values::NONE): CreateRateLimitOptions {
        return new CreateRateLimitOptions($description);
    }

    /**
     * @param string $description Description of this Rate Limit
     * @return UpdateRateLimitOptions Options builder
     */
    public static function update(string $description = Values::NONE): UpdateRateLimitOptions {
        return new UpdateRateLimitOptions($description);
    }
}

class CreateRateLimitOptions extends Options {
    /**
     * @param string $description Description of this Rate Limit
     */
    public function __construct(string $description = Values::NONE) {
        $this->options['description'] = $description;
    }

    /**
     * Description of this Rate Limit
     *
     * @param string $description Description of this Rate Limit
     * @return $this Fluent Builder
     */
    public function setDescription(string $description): self {
        $this->options['description'] = $description;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.CreateRateLimitOptions ' . $options . ']';
    }
}

class UpdateRateLimitOptions extends Options {
    /**
     * @param string $description Description of this Rate Limit
     */
    public function __construct(string $description = Values::NONE) {
        $this->options['description'] = $description;
    }

    /**
     * Description of this Rate Limit
     *
     * @param string $description Description of this Rate Limit
     * @return $this Fluent Builder
     */
    public function setDescription(string $description): self {
        $this->options['description'] = $description;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.UpdateRateLimitOptions ' . $options . ']';
    }
}